
chdir mm.info$(path)
mode 3,8

' load landscape images
page write 10 : cls

' water,plains,forest,mountains,dungeon,sign,castle,town
dim integer ocol(7)=(191,5373791,51200,5329247,0,13127936,16777215,16732671)
load png "Ultima1Overland.png"
for i = 1 to 9
  sprite read i+4,i*16,168,16,16
next i
sprite read 4,0,168,16,16   ' read basic water image
sprite write 4,0,184        ' tile it
sprite read 1,0,171,16,16
sprite read 2,0,170,16,16
sprite read 3,0,169,16,16

' load landscape characters
page write 11 : cls
load png "Ultima1Sprites.png"
for i = 1 to 8
  sprite read i+13,i*16,0,16,16
next i
ps = 14   ' current player sprite


page write 4 : cls
rbox 0,0,320,160,8,rgb(blue),rgb(blue)
 box 8,8,304,144,,0,0

pxo = 42 : pyo = 37
dngLevel = 0

astage = 0
settick 250, Animate

do
  DrawOverView(pxo,pyo)
  
  kp = asc(WaitUserKey(""))  ' wait for any player keypress
  select case kp
    case 128      ' North/Forward
      if dngLevel then
        MoveForward
      else
        MoveNSEW("North",0,-1)
      endif
    case 130      ' West/Turn Left
      if dngLevel then
        TurnLeft
      else
        MoveNSEW("West",-1,0)
      endif
    case 131      ' East/Turn Right
      if dngLevel then
        TurnRight
      else
        MoveNSEW("East",+1,0)
      endif
    case 129      ' South/Turn Around
      if dngLevel then
        TurnAround
      else
        MoveNSEW("South",0,+1)
      endif
    case asc("Q")   ' Quit
      ScrollCommands  0, "Quit! Are you sure?"
      if WaitUserKey("") = "Y" then end
  end select
loop

do : loop until inkey$ <> ""

'====================================================================
sub DrawOverView(xc,yc)
  local integer i,j
  static olds = astage  ' previous animate cycle step, looking for changes
  static oldxc = pxo
  static oldyc = pyo
  ' water,plains,forest,mountains,dungeon,sign,castle,town
  ' dim integer ocol(7)=(191,5373791,51200,5329247,0,13127936,16777215,16732671)

  if olds = astage and oldxc = pxo and oldyc = pyo then exit sub  ' nothing has changed
  olds = astage : oldxc = pxo : oldyc = pyo   ' save new values
  for j = -4 to 4
    for i = -9 to 9
      select case pixel(xc+i,yc+j,10)
        case ocol(0)  ' water
          sprite write 1+(olds and 3),152+i*16,72+j*16
        case ocol(1)  ' plains
          sprite write 5,152+i*16,72+j*16
        case ocol(2)  ' forest
          sprite write 6,152+i*16,72+j*16
        case ocol(3)  ' mountains
          sprite write 7,152+i*16,72+j*16
        case ocol(4)  ' dungeon
          sprite write 8,152+i*16,72+j*16
        case ocol(5)  ' sign
          sprite write 9,152+i*16,72+j*16
        case ocol(6)  ' castle
          sprite write 10+(olds and 2),152+i*16,72+j*16
        case ocol(7)  ' town
          sprite write 11+(olds+1 and 2),152+i*16,72+j*16
      end select
    next i
  next j
  sprite write ps,152,72
  page copy 4,0,B
end sub

'====================================================================
' Move to a new location
sub MoveNSEW(t$,dx,dy)
  ScrollCommands 10,left$("> "+t$+"       ",13)
  if pixel(pxo + dx,pyo + dy,10) = ocol(3) then
    ScrollCommands 10, "You can't pass the mountains."
  elseif pixel(pxo + dx,pyo + dy,10) = ocol(0) then
    ScrollCommands 10, "You can't walk on water."
  else
    pxo = pxo + dx
    pyo = pyo + dy
  endif
end sub

sub MoveForward     ' 11500 
    RewriteCommands 47, "  Forward    "
end sub

sub TurnRight
  RewriteCommands 47, "  Turn right "
  if pdx <> 0 then
    pdy=pdx : pdx=0
  else
    pdx=-pdy : pdy=0
  endif
end sub

sub TurnLeft
  RewriteCommands 47, "  Turn left  "
  if pdx <> 0 then
    pdy=-pdx : pdx=0
  else
    pdx=pdy : pdy=0
  endif
end sub

sub TurnAround
  RewriteCommands 47, "  Turn around"
  pdx=-pdx : pdy=-pdy
end sub

'====================================================================
' Scroll the text command window up one line and display text at very bottom
' window is located at (0,168) to (259,199)
' Handles long strings gracefully - well, not yet...
sub ScrollCommands xpos,t$
  blit 0,176,0,168,259,24   ' copy bottom 3 lines of text up one line
  box  0,192,259,8,0,0,0    ' erase bottom line of text
  RewriteCommands xpos,t$
end sub

'==================
' Add/change text on bottom line without scrolling
sub RewriteCommands xpos,t$
  text xpos,200, t$, LB
end sub

'====================================================================
' Wait for the user to enter a key. Converted to UPPER case
' Only keys in the pattern are accepted. Any key is fine if the pattern is empty.
function WaitUserKey(pat$) as string
  local qq$
  do while inkey$ <> "" : loop              ' clear any pre-existing keypresses
  do                                        ' wait for user to enter something
    DrawOverView(pxo,pyo)                   ' handle possible image animation
    qq$ = ucase$(inkey$)
    if qq$ <> "" and pat$ = "" then exit do ' no pattern so accept anything
  loop until instr(ucase$(pat$),qq$)        ' keep looping until it's a valid key
  WaitUserKey = qq$
end function

' Print message at cursor location and wait for key press
sub WaitForKeypress
  do while inkey$ <> "" : loop    ' clear any keystrokes
  print "   Press any key to continue...";
  do : loop until inkey$ <> ""    ' wait for keystroke
end sub

'====================================================================
' 4 stage animation - AND astage with 3 to get current stage
sub Animate
  inc astage
end sub
